package com.cs.cmsauto.pom.pageobj.base;


import java.util.Iterator;
import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

import com.cs.cmsauto.utilities.Constants;
import com.cs.cmsauto.utilities.Constants.Selectors;

public class Page {

	private static WebDriver driver;
	private WebElement el;
	private List<WebElement> els;
	private Selectors selectors;
	
	
	public Page(WebDriver driver)
	{
		this.driver = driver;
		
	}

//	public void constantTest() {
//		String str = selectors.xpath;
//	}
	
	public WebElement getWebElement(String locator)
	{
		return this.getWebElement(locator, "xpath");
		
	}
	public WebElement getWebElement(String type, String locator) {
		switch (type) {
			case "xpath":
				el = Page.driver.findElement(By.xpath(locator));
				el = this.driver.findElement(By.xpath(locator));
				break;
			case "classname":
				el = Page.driver.findElement(By.className(locator));
				el = this.driver.findElement(By.className(locator));
				break;
			case "css":
				el = Page.driver.findElement(By.cssSelector(locator));
				el = this.driver.findElement(By.cssSelector(locator));
				break;
			case "id":
				el = Page.driver.findElement(By.id(locator));
				el = this.driver.findElement(By.id(locator));
				break;
			case "linktext":
				el = Page.driver.findElement(By.linkText(locator));
				el = this.driver.findElement(By.linkText(locator));
				break;
			case "linktextpartial":
				el = Page.driver.findElement(By.partialLinkText(locator));
				el = this.driver.findElement(By.partialLinkText(locator));
				break;
			case "name":
				el = Page.driver.findElement(By.name(locator));
				el = this.driver.findElement(By.name(locator));
				break;
			case "tagname":
				el = Page.driver.findElement(By.tagName(locator));
				el = this.driver.findElement(By.tagName(locator));
				break;
			default:
				el = null;
				break;
		}

		return el;
	}
	public List<WebElement> getWebElements(String type, String locator)
	{
		switch (type) {
			case "xpath":
				els = this.driver.findElements(By.xpath(locator));
				break;
			case "classname":
				els = this.driver.findElements(By.className(locator));
				break;
			case "css":
				els = this.driver.findElements(By.cssSelector(locator));
				break;
			case "id":
				els = this.driver.findElements(By.id(locator));
				break;
			case "linktext":
				els = this.driver.findElements(By.linkText(locator));
				break;
			case "linktextpartial":
				els = this.driver.findElements(By.partialLinkText(locator));
				break;
			case "name":
				els = this.driver.findElements(By.name(locator));
				break;
			case "tagname":
				els = this.driver.findElements(By.tagName(locator));
				break;
			default:
				els = null;
				break;
		}

		return els;
	}

	
	
	public void visit(String url) {
		this.driver.get(url);
	}
	
	public boolean elementIsPresent(String type, String locator){
		if (this.getWebElements(type, locator).size() > 0 ) {
			return true;
		} else return false;
	}
	public boolean elementIsVisible(String type, String locator){
		if (this.elementIsPresent(type, locator)) {
			return this.getWebElement(type,locator).isDisplayed();
		} else return false;
	}
	public boolean elementIsEnabled(String type, String locator){
		if (this.elementIsPresent(type, locator)) {
			return this.getWebElement(type,locator).isEnabled();
		} else return false;
	}
	public boolean elementIsSelected(String type, String locator){
		if (this.elementIsPresent(type, locator)) {
			return this.getWebElement(type,locator).isSelected();
		} else return false;
	}
	
	
	public void click(String type, String locator){
		this.getWebElement(type,locator).click();
	}
	public void type(String type, String locator, String value){
		this.getWebElement(type,locator).sendKeys(value);
	}

	
	public String getElText(String type, String locator){
		return this.getWebElement(type,locator).getText();
	}	
	public String getElTagName(String type, String locator){
		return this.getWebElement(type,locator).getTagName();
	}
	public String getElAttribute(String type, String locator, String attribute){
		return this.getWebElement(type,locator).getAttribute(attribute);
	}
	public Dimension getElSize(String type, String locator, String attribute){
		return this.getWebElement(type,locator).getSize();
	}
	public Rectangle getElRectangle(String type, String locator, String attribute){
		return this.getWebElement(type,locator).getRect();
	}
	public String getElCssValue(String type, String locator, String propertyName){
		return this.getWebElement(type,locator).getCssValue(propertyName);
	}
	public Point getElLocationPoint(String type, String locator){
		return this.getWebElement(type,locator).getLocation();
	}
	public String getHref(String type, String locator){
		return this.getWebElement(type,locator).getAttribute("href");
	}
	public String getSrc(String type, String locator){
		return this.getWebElement(type,locator).getAttribute("src");
	}
	public String getClass(String type, String locator){
		return this.getWebElement(type,locator).getAttribute("class");
	}
	public String getName(String type, String locator){
		return this.getWebElement(type,locator).getAttribute("name");
	}
	public String getTag(String type, String locator){
		return this.getWebElement(type,locator).getTagName();
	}
	public String getId(String type, String locator){
		return this.getWebElement(type,locator).getAttribute("id");
	}
	public String getAlt(String type, String locator){
		return this.getWebElement(type,locator).getAttribute("alt");
	}
	
	
	public void select(String type, String locator, String value){
		// for single-value select control
		Select select = new Select(this.getWebElement(type, locator));
		select.selectByVisibleText(value);
	}
	
	public void hover(String type, String locator){}
	public void mouseDown(String type, String locator){}
	public void mouseUp(String type, String locator){}
	public void mouseDoubleClick(String type, String locator){}
	
	
	public void selectMultiByTextOne(String type, String locator, String text){
		// for multi-value select control
		Select select = new Select(this.getWebElement(type, locator));
		select.deselectAll();
		select.selectByVisibleText(text);
	}
	public void selectMultiByTextMany(String type, String locator, String[] texts){
		// for multi-value select control
		Select select = new Select(this.getWebElement(type, locator));
		select.deselectAll();
		for (String value : texts) {
			select.selectByVisibleText(value);
		}
	}
	public void selectMultiByValueOne(String type, String locator, String value){
		// for multi-value select control
		Select select = new Select(this.getWebElement(type, locator));
		select.deselectAll();
		select.selectByValue(value);
	}
	public void selectMultiByValueMany(String type, String locator, String[] values){
		// for multi-value select control
		Select select = new Select(this.getWebElement(type, locator));
		select.deselectAll();
		for (String value : values) {
			select.selectByValue(value);
		}
	}
	public void selectMultiByIndexOne(String type, String locator, int index){
		// for multi-value select control
		Select select = new Select(this.getWebElement(type, locator));
		select.deselectAll();
		select.selectByIndex(index);
	}
	public void selectMultiByIndexMany(String type, String locator, int[] indexs){
		// for multi-value select control
		Select select = new Select(this.getWebElement(type, locator));
		select.deselectAll();
		for (int index : indexs) {
			select.selectByIndex(index);
		}
	}
	
	
	public void selectRadioButton(String type, String locator){
		
	}
	public void selectCheckbox(String type, String locator){}
	public void selectCheckboxEnable(String type, String locator){}
	public void selectCheckboxDisable(String type, String locator){}
	public void dragFromTo(){}
	public void mouseClickDrag(){}

	
	public void switchToIFrame(String type, String locator){}
	public void switchToIFrameDefault(String type, String locator){}

	public void switchToWindow(){}
	public void switchToWindowFirst(){}
	
	
	public void browserBack(){}
	public void browserFwd(){}
	public void browserRefresh(){}
	

	
}
