﻿using AutoMapper;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AutoMapperPOC.Utils
{
    public class AutoMapperUtils
    {
        /// <summary>
        /// Utility Method for using AutoMapper to transform one Type to another Type ( TSource > TDest ).
        /// No CustomResolvers / Profiles are configured or used.
        /// </summary>
        /// <typeparam name="TSource">TYPE of the SOURCE object to map FROM</typeparam>
        /// <typeparam name="TDest">TYPE of the DESTINATION object to map TO</typeparam>
        /// <param name="source">source OBJECT to read values from</param>
        /// <returns>TDEST OBJECT with values successfully copied from any Matching Properties</returns>
        public static object AutoMapTSourceTDest<TSource, TDest>(object source)
        {
            Debug.WriteLine($"DEBUG::AutoMapping Objects: TSOURCE:[{typeof(TSource).Name}] :: TDEST:[{typeof(TDest).Name}] :: SOURCEOBJTYPE:[{source.GetType().Name}]");
            var config = new MapperConfiguration(cfg => cfg.CreateMap<TSource, TDest>());
            var mapper = new Mapper(config);
            TDest destObj = mapper.Map<TDest>(source);
            return destObj;
        }
    }
}
