﻿using AutoMapperPOC.Tests.Objects;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace AutoMapperPOC.Tests.Utils
{
    class CsvParserPoco1
    {
        public void GetFileContentsTest()
        {
            string filename = @"V:\source\repos\CSVHelperUtils\CSVHelperUtils.Tests\filedata.csv";
            string[] lines = System.IO.File.ReadAllLines(filename);
            string[] headers = lines[0].Split(',');
            string[] values;
            List<CsvPoco1> datalist = new List<CsvPoco1>();
            CsvPoco1 data;
            string currentColumn;

            for (int i = 1; i < lines.Length; i++)
            {
                data = new CsvPoco1();

                values = lines[i].Split(',');

                for (int h = 0; h < headers.Length; h++)
                {
                    currentColumn = headers[h];

                    PropertyInfo propInfo = data.GetType().GetProperty(currentColumn);
                    Console.WriteLine("HEADER NAME: " + currentColumn + ":: PROP NAME: " + propInfo.PropertyType.Name + " :: VALUE: " + values[h]);
                    if (propInfo != null)
                    {
                        //data.GetType().GetProperty(currentColumn).SetValue(data, Int32.Parse(values[h]));
                        ParseType(currentColumn, propInfo.PropertyType, values[h], data);
                    }
                }
                datalist.Add(data);
            }
            PrintDataObjects(datalist);
        }

        private void ParseType(string column, Type type, string value, CsvPoco1 data)
        {
            if (type == typeof(Int32))
            {
                data.GetType().GetProperty(column).SetValue(data, Int32.Parse(value));
            }
            else if (type == typeof(double))
            {
                data.GetType().GetProperty(column).SetValue(data, double.Parse(value));
            }
            else if (type == typeof(string))
            {
                data.GetType().GetProperty(column).SetValue(data, value);
            }
        }

        private void PrintDataObjects(List<CsvPoco1> datalist)
        {
            foreach (CsvPoco1 data in datalist)
            {
                foreach (PropertyInfo propInfo in data.GetType().GetRuntimeProperties())
                {
                    Type type = propInfo.PropertyType;
                    Console.WriteLine(propInfo.GetValue(data));
                }
                Console.WriteLine("=======================");
            }
        }
    }
}
