﻿using AutoMapperPOC.Utils;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AutoMapperPOC.Tests.Tests
{
    [TestClass]
    public class CsvToDataTableTests
    {
        private string _filePath = @"V:\source\repos\AutoMapperPOC\AutoMapperPOC.Tests\TestData\filedata.csv";
        private string _filePathInvalid = @"ZZ:\source\repos\AutoMapperPOC\AutoMapperPOC.Tests\TestData\filedata.csv";
        string message = "";

        [TestMethod]
        public void FileNotFoundTest()
        {
            try
            {
                DataTableUtils.ParseFileToDataTable(_filePathInvalid);
                message = $"An Exception should be thrown for invalid file path:[{_filePathInvalid}]";
                Debug.WriteLine(message);
                Assert.Fail(message);
            }
            catch (Exception e)
            {
                message = $"Verify an assertion is thrown containing 'not found'.\n{e.Message}";
                Debug.WriteLine(message);
                Assert.IsTrue(e.Message.Contains("not found"),message);
            }
        }

        [TestMethod]
        public void FileFoundTest()
        {
            try
            {
                message = $"An Exception should NOT be thrown for VALID file path:{_filePath}";
                Debug.WriteLine(message);
                DataTableUtils.ParseFileToDataTable(_filePath);
            }
            catch (Exception e)
            {
                Assert.Fail(message);
            }
        }

        [TestMethod]
        public void ParseCsvToDataTableProcessingTest()
        {
            message = $"Read CSV at:[{_filePath}] to DataTable";
            Debug.WriteLine(message);
            DataTable dt = DataTableUtils.ParseFileToDataTable(_filePath);
            Debug.WriteLine(DataTableUtils.FetchDataTableContents(dt));
        }
    }
}
