﻿using AutoMapperPOC.Utils;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AutoMapperPOC.Tests.Tests.Base
{
    [TestClass]
    public class TestBase_Automapper_MockingTests : TestBase_Automapper_Mocking
    {
        string stringSource = "";
        string stringDest = "";
        int intSource = 0;
        int intDest = 0;
        double doubleSource = 01.02;
        double doubleDest = 01.02;


        [TestMethod]
        public void AutoMapperCopyObjectsTest()
        {
            _dest= (DestObject)AutoMapperCopyObjects<SourceObject, DestObject>(_source);
            Debug.WriteLine($"AutoMapResult:SRC : [{_source.Name}, {_source.Id}, {_source.IsCorrect}]");
            Debug.WriteLine($"AutoMapResult:DEST: [{_dest.Name}, {_dest.Id}, {_dest.IsCorrect}]");
        }

        [TestMethod]
        public void AutoMapperSetupExamplesTest()
        {
            AutoMapperUtils.AutoMapTSourceTDest<string, string>(stringSource);
            AutoMapperCopyObjects<string, string>(stringSource);
            AutoMapperUtils.AutoMapTSourceTDest<int, string>(intSource);
            AutoMapperCopyObjects<int, string>(intSource);
            AutoMapperUtils.AutoMapTSourceTDest<int, double>(intSource);
            AutoMapperCopyObjects<int, double>(intSource);
        }
    }
}
