﻿using AutoMapper;
using AutoMapperPOC.Tests.Objects;
using AutoMapperPOC.Utils;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AutoMapperPOC.Tests.Tests.Base
{
    [TestClass]
    public class TestBase_Automapper_Mocking 
    { 

        protected readonly SourceObject _source = new SourceObject()
                    {
                        Name = "source1",
                        Id = 1,
                        IsCorrect = true
                    };
        protected DestObject _dest;

        /// <summary>
        /// TestBase Util Method for Copying like objects using AutoMapper
        /// </summary>
        /// <typeparam name="TSource">Source Object Type</typeparam>
        /// <typeparam name="TDest">Destination Object Type</typeparam>
        /// <param name="source">Source Object</param>
        /// <returns>Destination Object with successfully copied Property values</returns>
        protected object AutoMapperCopyObjects<TSource,TDest>(object source)
        {
            Debug.WriteLine($"TESTBASE::AutoMapping Objects: TSOURCE:[{typeof(TSource).Name}] :: TDEST:[{typeof(TDest).Name}] :: SOURCEOBJTYPE:[{source.GetType().Name}]");
            return AutoMapperUtils.AutoMapTSourceTDest<TSource, TDest>(source);
        }

    }

    public class SourceObject
    {
        public string Name { get; set; }
        public int Id { get; set; }
        public bool IsCorrect { get; set; }

    }

    public class DestObject
    {
        public string Name { get; set; }
        public int Id { get; set; }
        public bool IsCorrect { get; set; }

    }

}
